function plotgr(Nodes,Edges,fig1,nodsiz,labels)
% function plotgr(Nodes,Edges,fig1,nodsiz,labels)
%
% plots a graph 
%
% INPUT
% Nodes:	node coordinates of the graph
% Edges:	edge list of the graph
% fig1:	number of figure on which to graph
% nodsiz:(graphical) size of nodes
% labels:label the nodes (1) or not(0)	
%
% OUTPUT
% a plot of the graph

figure(fig1)
clf(fig1)
N=length(Nodes);
M=length(Edges);
xmax=max(Nodes(:,1));
ymax=max(Nodes(:,2));

for m=1:M
	line([Nodes(Edges(m,1),1) Nodes(Edges(m,2),1)],[Nodes(Edges(m,1),2) Nodes(Edges(m,2),2)],'LineWidth',5,'Color','k')
end
hold on
plot(Nodes(:,1),Nodes(:,2),'ro','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',nodsiz)
axis([0 xmax+1 0 ymax+1])
if	labels
	for n=1:N
		text(Nodes(n,1)-0.05,Nodes(n,2),num2str(n))
	end
end
hold off
axis off